
# Locate the glfw library
#
# FIND_PACKAGE (GLFW REQUIRED)
# INCLUDE_DIRECTORIES (${GLFW_INCLUDE})
# ADD_EXECUTABLE (executable ${EXECUTABLE_SRCS})
# TARGET_LINK_LIBRARIES (executable ${GLFW_LIBRARY})
#
# TODO:
# Allow the user to select to link to a shared library or to a static library.
# Define windows env variable (GLFW_DIR) which points to the root of glfw

#Search for the include file...

SET (GLFW_SEARCH_PATHS
	/usr/local
	/usr
	/opt/local
	/opt
	)


FIND_PATH(GLFW_INCLUDE_DIRS GL/glfw.h DOC "Path to GLFW include directory."
  HINTS
  $ENV{GLFW_DIR}
  PATH_SUFFIX include #For finding the include file under the root of the glfw expanded archive, typically on Windows.
  PATHS ${GLFW_SEARCH_PATHS}
  /usr/include/
  /usr/local/include/
  # By default headers are under GL subfolder
  /usr/include/GL
  /usr/local/include/GL
 
)

FIND_LIBRARY(GLFW_LIBRARIES DOC "Absolute path to GLFW library."
  NAMES glfw GLFW.lib
  HINTS
  $ENV{GLFW_DIR}
  PATH_SUFFIXES lib/win32 #For finding the library file under the root of the glfw expanded archive, typically on Windows.
  PATHS ${GLFW_SEARCH_PATHS}
  /usr/local/lib
  /usr/lib
)

SET(GLFW_LIBRARY ${GLFW_LIBRARIES})
SET(GLFW_INCLUDE ${GLFW_INCLUDE_DIRS}) 
SET(GLFW_FOUND "NO")
IF(GLFW_LIBRARY AND GLFW_INCLUDE)
	SET(GLFW_FOUND "YES")
ENDIF(GLFW_LIBRARY AND GLFW_INCLUDE)
