// Program:  ActiveDebug.cpp - Active Debug Class
// Language: C++
// Author:   Daniel Kennedy (Syn9)
//
// Copyright (c) 2008-2010
// ____________________________________________________________________________
#include "ActiveDebug.h"

namespace basecode
{
	void ActiveDebug::init(int inc_key, int dec_key, float val, float factor)
	{
		current = val;
		velocityFactor = factor;
		velocity = 0;
		incKey = inc_key;
		decKey = dec_key;
	}

	ActiveDebug::ActiveDebug(int inc_key, int dec_key, float val, float factor)
	{
		init(inc_key, dec_key, val, factor);
	}

	ActiveDebug::ActiveDebug(int inc_key, int dec_key, float val)
	{
		init(inc_key, dec_key, val, 1);
	}

	ActiveDebug::ActiveDebug(int inc_key, int dec_key)
	{
		init(inc_key, dec_key, 0, 1);
	}

	ActiveDebug::ActiveDebug()
	{
		init(0, 0, 0, 1);
	}

	void ActiveDebug::set(float val)
	{
		current = val;
		velocity = 0;
	}

	void ActiveDebug::update()
	{
		float w0 = .001f * velocityFactor;
		float v0 = velocity;
		
		if (glfwGetKey(GLFW_KEY_LCTRL)) w0 *= 10;
		if (glfwGetKey(GLFW_KEY_LSHIFT)) w0 *= .1f;

		if (glfwGetKey(incKey)) velocity += w0;
		if (glfwGetKey(decKey)) velocity -= w0;
		if (v0 == velocity) velocity /= 2;

		current += velocity;
	}

	float ActiveDebug::value()
	{
		return current;
	}
}