#ifndef __ENEMY_OBJECT_H__
#define __ENEMY_OBJECT_H__

#include "ISyncObject.h"
#include "Physics.h"
#include "Game/IGameObject.h"


// Enemy Ship Types
#define ENEMY_LIGHT 0

class EnemyObject: public basecode::Game::IGameObject, public basecode::ISyncObject
{
private:
	basecode::Physics::PhysicsObject po;
	unsigned int modelid;
	unsigned int shipType;
	bool remove;

public:
	EnemyObject();
	
	void collision(unsigned int obj, basecode::Math::vec3f pnt);
	bool garbage();
	void render();
	void render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix);
	basecode::Physics::PhysicsObject* physics();
	void sync(ISyncObject & syncObject, double time);
	void update(float interval);
};

#endif __ENEMY_OBJECT_H__
