#ifndef __BASECODE_GAME_INPUTCONVERTER_H__
#define __BASECODE_GAME_INPUTCONVERTER_H__

#include "../RawInputCode.h"
#include "../InputObject.h"

namespace basecode { namespace Game {

	class InputConverter
	{
	private:
		Input::RawInputCode _code;
		bool _convert_to_axis;
		float _floatValue;

		//this is probably the wrong way to go about this...
		bool _wasLastAxisTriggeredTrue;

		InputConverter();
	public:

		static InputConverter DigitalizeAxis(Input::RawInputCode axis, float threshold);
		static InputConverter AnalogizeButton(Input::RawInputCode button, float multiplier);

		bool GetAxisTriggered(Input::InputObject & inputObject);
		bool GetAxisJustTriggered(Input::InputObject & inputObject);
		bool GetAxisUnTriggered(Input::InputObject & inputObject);
		bool GetAxisJustUnTriggered(Input::InputObject & inputObject);

		float GetButtonAxis(Input::InputObject & inputObject); 
	};

}}

#endif  __BASECODE_GAME_INPUTCONVERTER_H__
