#include "InputMapping.h"

namespace basecode { namespace Game {

	void InputMapping::AddMapping(int gameCode, Input::RawInputCode rawCode)
	{
		_mappings[gameCode].push_back(rawCode);
	}

	std::list<Input::RawInputCode> InputMapping::GetMappings(int gameCode)
	{
		if(_mappings.find(gameCode) != _mappings.end()) return _mappings[gameCode];
		return std::list<Input::RawInputCode>();
	}

}}