#ifndef __BASECODE_GAME_INPUTMAPPING_H__
#define __BASECODE_GAME_INPUTMAPPING_H__

#include <boost/unordered_map.hpp>
#include <list>

#include "../RawInputCode.h"
#include "../IResolvable.h"
#include "../ICanBeASetting.h"
//#include "InputConverter.h"

namespace basecode { namespace Game {
	class InputMapping : public System::IResolvable
	{
	private:
		boost::unordered_map< int, std::list<Input::RawInputCode> > _mappings;
		//boost::unordered_map<int, std::list<InputConverter>> _conversions;
	public:
		void AddMapping(int gameCode, Input::RawInputCode rawCode);
		//void AddMapping(int gameCode, InputConverter converter);

		std::list<Input::RawInputCode> GetMappings(int gameCode);
		//std::list<InputConverter> GetConversions(int gameCode);
	};
}}

#endif  __BASECODE_GAME_INPUTMAPPING_H__