#include <boost/foreach.hpp>
#include <utility>
#include "Kernel.h"

namespace basecode { namespace Game {

	void Kernel::Init()
	{
		typedef std::pair<size_t, IInitSubProcess*>  processPair_t ;
		BOOST_FOREACH(processPair_t s, _initSubProcessList)
		{
			s.second->Run();
		}
	}

	void Kernel::Run()
	{
		typedef std::pair<size_t, ISubProcess*>  processPair_t ;
		BOOST_FOREACH(processPair_t s, _subProcessList)
		{
			s.second->Run();
		}
	}

	void Kernel::Shutdown()
	{
		typedef std::pair<size_t, IShutdownSubProcess*>  processPair_t ;
		BOOST_FOREACH(processPair_t s, _shutdownSubProcessList)
		{
			s.second->Run();
		}
	}

}}