#include "KernelFactory.h"

#include "ISyncNetworkSubProcess.h"
#include "IPrepareInputSubProcess.h"
#include "IInputSubProcess.h"
#include "IRunLogicSubProcess.h"
#include "IStartRenderingSubProcess.h"
#include "IRenderSubProcess.h"
#include "IFinishRenderingSubProcess.h"
#include "IRenderInitSubProcess.h"
#include "IRenderShutdownSubProcess.h"
#include "IModuleInitSubProcess.h"
#include "IModuleShutdownSubProcess.h"

#include "../Resolver.h"

namespace basecode { namespace Game {

	Kernel * KernelFactory::Create(bool networking)
	{
		Kernel * kernel = new Kernel();

		kernel->
			AddInitSubProcess<IRenderInitSubProcess>(System::Resolve<IRenderInitSubProcess>()).
			AddInitSubProcess<IModuleInitSubProcess>(System::Resolve<IModuleInitSubProcess>());
			

		if(networking)
		{
			kernel->AddSubProcess<ISyncNetworkSubProcess>(System::Resolve<ISyncNetworkSubProcess>());
		}

		kernel->
			AddSubProcess<IPrepareInputSubProcess>(System::Resolve<IPrepareInputSubProcess>()).
			AddSubProcess<IInputSubProcess>(System::Resolve<IInputSubProcess>()).
			AddSubProcess<IRunLogicSubProcess>(System::Resolve<IRunLogicSubProcess>()).
			AddSubProcess<IStartRenderingSubProcess>(System::Resolve<IStartRenderingSubProcess>()).
			AddSubProcess<IRenderSubProcess>(System::Resolve<IRenderSubProcess>()).
			AddSubProcess<IFinishRenderingSubProcess>(System::Resolve<IFinishRenderingSubProcess>());

		kernel->
			AddShutdownSubProcess<IModuleShutdownSubProcess>(System::Resolve<IModuleShutdownSubProcess>()).
			AddShutdownSubProcess<IRenderShutdownSubProcess>(System::Resolve<IRenderShutdownSubProcess>());

		return kernel;
	}

	Kernel * KernelFactory::CreateKernel()
	{
		return Create(false);
	}

	Kernel * KernelFactory::CreateKernelWithNetworking()
	{
		return Create(true);
	}
}}
