#define GLFW_DLL
#include <GL/glfw.h>
#include "GlfwModule.h"

namespace basecode { namespace Graphics {

		GlfwModule::GlfwModule(int resx, int resy, bool windowed, std::string title)
		{
			_resx = resx;
			_resy = resy;
			_windowed = windowed;
			_title = title;
			_isInit = false;
		}

		///No run-specific data should be cleaned up in here, that should all be in Shutdown()
		GlfwModule::~GlfwModule()
		{
		}

		//void GlfwModule::VerifySettings(System::Settings & settings)
		//{
		
		//}

		///Module initialization
		void GlfwModule::Init()
		{
			if(_isInit) return;
			_isInit = true;
			glfwInit();
			glfwOpenWindowHint(GLFW_WINDOW_NO_RESIZE, GL_TRUE);
			glfwOpenWindow(_resx, _resy, 8,8,8,8,0,0, _windowed ? GLFW_WINDOW : GLFW_FULLSCREEN);
			glfwSetWindowTitle(_title.c_str());

			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();

			glViewport(0, 0, _resx - 1, _resy - 1);
			gluOrtho2D(0, _resx - 1, _resy - 1,0);

			glShadeModel(GL_SMOOTH);
			glClearDepth(1.0);
			glEnable(GL_COLOR_MATERIAL);
			glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
			glAlphaFunc(GL_GREATER, .1f);
			glMaterialf(GL_FRONT, GL_SHININESS, 75);
			glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	
			glCullFace(GL_BACK);
			glEnable(GL_CULL_FACE);
			glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glEnable(GL_BLEND);
			glPolygonMode(GL_FRONT, GL_FILL);
	
			glDisable(GL_DEPTH_TEST);
			glDisable(GL_LIGHTING);
			glDepthMask(GL_FALSE);

		}

		///Process input
		void GlfwModule::HandleInput(Input::InputObject & object)
		{
			object.UpdateInput();
		}

		///Run module logic etc
		void GlfwModule::Run()
		{
			//Placeholder
		}

		///Render visuals
		void GlfwModule::Render()
		{
		}

		///Module shutdown
		void GlfwModule::Shutdown()
		{
			if(!_isInit) return;
			_isInit = false;
			glfwCloseWindow();
			glfwTerminate();
		}

}}