#include "GlfwSharedObject.h"
#include "SettingsGetValueT.h"
#include "Resolver.h"
#include "GlfwConstants.h"


namespace basecode { namespace Game {

	SharedObject::SharedObject()
	{
		_isInit = false;
		_resx = GET_SETTING(Glfw::resx,int);
		_resy = GET_SETTING(Glfw::resy,int);
		_windowed = GET_SETTING(Glfw::windowed, bool);
		_title = GET_SETTING(Glfw::windowtitle,std::string);
	}
	
	void SharedObject::SetIsInit(bool isInit)
	{
		_isInit = isInit;
	}
	
	bool& SharedObject::GetIsInit()
	{
		return _isInit;
	}

	void SharedObject::SetResx(int resx)
	{
		_resx = resx;
	}

	int& SharedObject::GetResx()
	{
		return _resx;
	}

	void SharedObject::SetResy(int resy)
	{
		_resy = resy;
	}

	int& SharedObject::GetResy()
	{
		return _resy;
	}

	void SharedObject::SetWindowed(bool windowed)
	{
		_windowed = windowed;
	}

	bool& SharedObject::GetWindowed()
	{
		return _windowed;
	}

	void SharedObject::SetTitle(std::string& title)
	{
		_title = title;
	}

	std::string& SharedObject::GetTitle()
	{
		return _title;
	}

}}