#include <GL/glew.h>
#define GLFW_DLL
#include <GL/glfw.h>

#include "GlfwSharedObject.h"
#include "GlfwSubProcessStack.h"
#include "Resolver.h"

namespace basecode { namespace Game {

	void GlfwInitSubProcess::Run()
	{
		SharedObject * so = System::Resolve<SharedObject>();
		int resx = so->GetResx();
		int resy = so->GetResy();
		bool windowed = so->GetWindowed();
		std::string title = so->GetTitle();

		if(so->GetIsInit()) return;
		so->SetIsInit(true);
	
		glfwInit();
		glfwOpenWindowHint(GLFW_WINDOW_NO_RESIZE, GL_TRUE);

		glfwOpenWindowHint(GLFW_FSAA_SAMPLES, 4); // 4x antialiasing
		glfwOpenWindowHint(GLFW_OPENGL_VERSION_MAJOR, 3); // We want OpenGL 3.3
		glfwOpenWindowHint(GLFW_OPENGL_VERSION_MINOR, 3);
		glfwOpenWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE); //We don't want the old OpenGL

		glfwOpenWindow(resx, resy, 8,8,8,8,0,0, windowed ? GLFW_WINDOW : GLFW_FULLSCREEN);
		glfwSetWindowTitle(title.c_str());

		// Initialize GLEW
		glewExperimental=true; // Needed in core profile
		if (glewInit() != GLEW_OK) {
			fprintf(stderr, "Failed to initialize GLEW\n");
		}

		glClearColor(0, 0, 0, 1);
		glClearDepth(1.0);
		glEnable(GL_DEPTH_TEST);
		glDepthMask(GL_TRUE);
		glDepthFunc(GL_LESS);

		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		// see zerogtr/sphere for other variables.
	}

	void GlfwStartRenderingSubProcess::Run()
	{
		// prep rendering
		//glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
		//glPushMatrix();
	}

	void GlfwFinishRenderingSubProcess::Run()
	{
		// cleanup rendering
		/*glPopMatrix();
		glFlush();
		glfwSwapBuffers();*/
	}

	void GlfwShutdownSubProcess::Run()
	{
		SharedObject * so = System::Resolve<SharedObject>();

		if(!so->GetIsInit()) return;
		so->SetIsInit(false);
		glfwCloseWindow();
		glfwTerminate();
	}

	
	GlfwInitSubProcess::~GlfwInitSubProcess(){}
	GlfwStartRenderingSubProcess::~GlfwStartRenderingSubProcess(){}
	GlfwFinishRenderingSubProcess::~GlfwFinishRenderingSubProcess(){}
	GlfwShutdownSubProcess::~GlfwShutdownSubProcess(){}
}}