#include "TalonFiveModule.h"
#include "Resolver.h"
#include "TalonFiveConstants.h"
#include "Settings.h"
#include "SettingsGetValueT.h"
#include "Utility.h"
#define GLFW_DLL
#include <GL/glfw.h>
#include "GlfwConstants.h"

#include <math.h>
#include <string>
#include <fstream>
#include <boost/serialization/vector.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>


namespace TalonFive {

	void Module::HandleInput(basecode::Input::InputObject & _object)
	{
		basecode::Game::InputObject object = basecode::Game::InputObject(&_object, basecode::System::Resolve<GameInputMapping>());
		
		int xres = GET_SETTING(basecode::Game::Glfw::resx, int);
		int yres = GET_SETTING(basecode::Game::Glfw::resy, int);

		if(object.IsKeyDown(Input_Exit))
		{
			basecode::System::Resolve<basecode::System::Settings>()->SetValue(TalonFive::exit, true);
			
			//SET_SETTING(TalonFive::exit,true);
		}
		if(object.IsKeyDown(Input_Reset))
		{
			//basecode::System::Resolve<basecode::System::Settings>()->SetValue(TalonFive::reset, true);
			SET_SETTING(TalonFive::reset,true);
		}

		if (glfwGetKey('Q'))
		{
			ad_x.set(0);
			ad_y.set(0);
			ad_z.set(0);
			for (unsigned int a = 0; a < objList.size(); a++)
			{
				objList[a]->physics()->linearMomentum.set(0, 0, 0);
			}
		}

		if (kbwait < timer.time())
		{
			if (glfwGetKey(GLFW_KEY_SPACE))
			{
				for (unsigned int a = 1; a < objList.size(); a++)
				{
					objList[a]->physics()->setMass(objList[a]->physics()->hull.surfaceArea * massDensity);
					objList[a]->physics()->linearMomentum = basecode::Math::vec3f(basecode::rnd() - .5f, basecode::rnd() - .5f, 0);
					objList[a]->physics()->linearMomentum.normalize();
					objList[a]->physics()->linearMomentum.scale(basecode::rnd() * 100);

					//objList[a].linearMomentum += basecode::Math::vec3f(basecode::rnd() * w - .5f * w, basecode::rnd() * w - .5f * w, 0) * objList[a].mass;
					//objList[a].force = basecode::Math::vec3f(basecode::rnd() * w - .5f * w, basecode::rnd() * w - .5f * w, 0) * objList[a].mass;
				}
				kbwait = (float)timer.time() + .3f;
			}

		}

		int d;
		basecode::vec2f analog;
		
		bool action_tether = false;
		bool action_disable_tether = false;
		bool action_halt = false;
		bool action_pair = false;
		
		for (int i = 0; i < 16; i++)
		{
			if (glfwGetJoystickParam(GLFW_JOYSTICK_1 + i, GLFW_PRESENT) == GL_TRUE)
			{
				if (gamepad[i].connected == false) printf("Gamepad %d Connected\n", i);

				gamepad[i].connected = true;
				gamepad[i].nAxes = glfwGetJoystickParam(GLFW_JOYSTICK_1 + i, GLFW_AXES);
				gamepad[i].nButtons = glfwGetJoystickParam(GLFW_JOYSTICK_1 + i, GLFW_BUTTONS);

				d = glfwGetJoystickPos(GLFW_JOYSTICK_1 + i, &gamepad[i].axisValue[0], 16);
				d = glfwGetJoystickButtons(GLFW_JOYSTICK_1 + i, &gamepad[i].buttons[0], 32);

				for (d = 0; d < 16; d++)
				{
					if (gamepad[i].axisValue[d] < gamepad[i].minValue[d]) gamepad[i].minValue[d] = gamepad[i].axisValue[d];
					if (gamepad[i].axisValue[d] > gamepad[i].maxValue[d]) gamepad[i].maxValue[d] = gamepad[i].axisValue[d];
				}

				analog.set(gamepad[i].axisValue[0], gamepad[i].axisValue[1]);
				
				if (kbwait < timer.time())
				{
					if (gamepad[i].buttons[0] == 1) action_tether = true;
					if (gamepad[i].buttons[1] == 1) action_halt = true;
					if (gamepad[i].buttons[2] == 1) action_disable_tether = true;
					if (gamepad[i].buttons[3] == 1) action_pair = true;
				}

			} else {
				if (gamepad[i].connected == true)
				{
					gamepad[i].connected = false;
					for (int d = 0; d < 16; d++)
					{
						gamepad[i].axisValue[d] = 0;
						gamepad[i].minValue[d] = 0;
						gamepad[i].maxValue[d] = 0;
						gamepad[i].buttons[d * 2] = 0;
						gamepad[i].buttons[d * 2 + 1] = 0;
					}
				}
			}
		}

		if (timer.time() > 1 && analog.magnitude2() > .01f)
		{

			basecode::vec2f shipAnalog = basecode::vec2f(cos(shipAngle), sin(shipAngle));
			shipAnalog += (analog - shipAnalog) * timer.delta() / .1f;

			float pi = 3.14159f;
			float mag = analog.magnitude();
			shipAngle = atan2(shipAnalog.y, shipAnalog.x);
			
			objList[0]->physics()->orientation.loadIdentity();
			objList[0]->physics()->orientation.rotate(90, 0, 0);
			objList[0]->physics()->orientation.rotate(0, shipAngle * 180 / pi - 90, 0);

			basecode::Math::vec3f vx, vy, vz;
			vx = objList[0]->physics()->orientation.x();
			vy = objList[0]->physics()->orientation.y();
			vz = vx.cross(vy);
			vy = vz.cross(vx);
			vx.normalize();
			vy.normalize();
			vz.normalize();
			objList[0]->physics()->orientation.orient(vx, vy, vz);
			objList[0]->physics()->position.z = 0;

			objList[0]->physics()->force = basecode::Math::vec3f(0, 0, -3000 * mag).multiply(objList[0]->physics()->orientation);
		}


		if (action_tether)
		{
			
			kbwait = (float)timer.time() + .3f;
			TetherObject *to = new TetherObject();
			basecode::Physics::PhysicsObject *po = to->physics();

			to->setObjList(&objList);
			to->pair(objList[0], 15);
			if (tetherBeam.tetherB)
			{
				to->pair(tetherBeam.tetherB, 0);
				((TetherObject*)tetherBeam.tetherB)->pair(to, 0);
			}

			po->linearMomentum = objList[0]->physics()->linearMomentum / objList[0]->physics()->mass;
			po->hull.vertices.push_back(basecode::Math::vec3f(0, 0, 0));
			po->position.set(objList[0]->physics()->position);

			basecode::Math::vec3f force;
			force = basecode::Math::vec3f(0, 0, -1).multiply(objList[0]->physics()->orientation) * 6000;

			po->force.set(force);
			po->mass = 1;
			to->k = 500;

			if (tetherBeam.tetherA) 
			{
				for (unsigned int i = 0; i < objList.size(); i++)
				{
					if (objList[i] == tetherBeam.tetherA)
					{
						objList.erase(objList.begin() + i);
						break;
					}
				}
			}
			if (tetherBeam.tetherB) 
			{
				for (unsigned int i = 0; i < objList.size(); i++)
				{
					if (objList[i] == tetherBeam.tetherB)
					{
						objList.erase(objList.begin() + i);
						break;
					}
				}
			}

			tetherBeam.init();
			tetherBeam.create(to);
			objList.push_back(to);
		}

		if (action_pair && tetherBeam.tetherA)
		{
			kbwait = (float)timer.time() + .3f;
			TetherObject *to = new TetherObject();
			basecode::Physics::PhysicsObject *po = to->physics();

			to->setObjList(&objList);
			to->pair(tetherBeam.tetherA, 0);

			po->linearMomentum = objList[0]->physics()->linearMomentum / objList[0]->physics()->mass;
			po->hull.vertices.push_back(basecode::Math::vec3f(0, 0, 0));
			po->position.set(objList[0]->physics()->position);

			basecode::Math::vec3f force;
			force = basecode::Math::vec3f(0, 0, -1).multiply(objList[0]->physics()->orientation) * 6000;

			po->force.set(force);
			po->mass = 1;
			to->k = 500;

			if (tetherBeam.tetherB)
			{
				for (unsigned int i = 0; i < objList.size(); i++)
				{
					if (objList[i] == tetherBeam.tetherB)
					{
						objList.erase(objList.begin() + i);
						break;
					}
				}
			}

			((TetherObject*)tetherBeam.tetherA)->pair(to, 0);

			tetherBeam.pair(to);
			objList.push_back(to);
			tetherBeam.setExpiration((float)timer.time() + 5);
			tetherList.push_back(tetherBeam);
			tetherBeam.init();
		}

		if (action_disable_tether)
		{
			for (unsigned int i = 0; i < objList.size(); i++)
			{
				if (objList[i] == tetherBeam.tetherA)
				{
					objList.erase(objList.begin() + i);
					i--;
				}
				if (objList[i] == tetherBeam.tetherB)
				{
					objList.erase(objList.begin() + i);
					i--;
				}
			}
			tetherBeam.disable();
		}

		if (action_halt)
		{
			objList[0]->physics()->force.set(objList[0]->physics()->linearMomentum * -timer.delta() / ptimer.min_interval);
			//objList[0]->physics()->linearMomentum -= objList[0]->physics()->linearMomentum * timer.delta();
		}
				
		// Old Mouse Code
		//-----------------------------

		//mouse.position.x = (int)object.GetAxis(Input_Mouse_X);
		//mouse.position.y = (int)object.GetAxis(Input_Mouse_Y);

		//if (timer.time() < 1) return;

		//basecode::vec3f mv, mp;

		//mp.set((float)mouse.posxe - (float)mouse.posxs, (float)mouse.posye - (float)mouse.posys, (float)mouse.posze - (float)mouse.poszs);
		//mp.normalize();

		//mp *= mp.dot(objList[0]->physics()->position - basecode::vec3f((float)mouse.posxs, (float)mouse.posys, (float)mouse.poszs));
		//mv.x = (float)mouse.posxs + mp.x;
		//mv.y = (float)mouse.posys + mp.y;
		//mv.z = 0;//mouse.poszs + mp.z;
		//mv -= objList[0]->physics()->position;
		//mv.normalize();

		//basecode::Matrix mtx = objList[0]->physics()->orientation;
		//
		//double d0, d1;
		//d0 = mv.dot(basecode::vec3f(0, 0, -1).multiply(mtx));
		//mtx.rotate(0, 1, 0);
		//d1 = mv.dot(basecode::vec3f(0, 0, -1).multiply(mtx));

		//float maxAn = (float)d0;
		//maxAn = acos(maxAn) * 180 / 3.14159f;
		//
		//maxAn *= 15 * timer.delta();
		//
		//if (maxAn > 1)
		//{
		//	if (d0 < d1)
		//		objList[0]->physics()->orientation.rotate(0, maxAn, 0);
		//	else
		//		objList[0]->physics()->orientation.rotate(0, -maxAn, 0);

		//	basecode::Math::vec3f vx, vy, vz;
		//	vx = objList[0]->physics()->orientation.x();
		//	vy = objList[0]->physics()->orientation.y();
		//	vz = vx.cross(vy);
		//	vy = vz.cross(vx);
		//	vx.normalize();
		//	vy.normalize();
		//	vz.normalize();
		//	objList[0]->physics()->orientation.orient(vx, vy, vz);
		//	objList[0]->physics()->position.z = 0;
		//}
		

		if (glfwGetKey(GLFW_KEY_UP)) objList[0]->physics()->force = basecode::Math::vec3f(0, 0, -3000).multiply(objList[0]->physics()->orientation);
		if (glfwGetKey(GLFW_KEY_DOWN)) objList[0]->physics()->force = basecode::Math::vec3f(0, 0, 1500).multiply(objList[0]->physics()->orientation);
		if (glfwGetKey(GLFW_KEY_LEFT)) objList[0]->physics()->force = basecode::Math::vec3f(-2000, 0, 0).multiply(objList[0]->physics()->orientation);
		if (glfwGetKey(GLFW_KEY_RIGHT)) objList[0]->physics()->force = basecode::Math::vec3f(2000, 0, 0).multiply(objList[0]->physics()->orientation);

	}
}