#include "InputObject.h"
#define GLFW_DLL
#include <GL/glfw.h>

namespace basecode { namespace Input {

	InputObject::InputObject(int numJoystick)
	{
		_numJoystick = numJoystick;
	}

	void InputObject::UpdateInput()
	{
		glfwGetJoystickButtons(_numJoystick, _joybuttons, 16);
		glfwGetJoystickPos(_numJoystick, _joyaxes, 8);
		glfwGetMousePos(&_mousex, &_mousey);
		_mousewheel = glfwGetMouseWheel();
	}

	bool InputObject::IsKeyDown(RawInputCode code)
	{
		if(code >= raw_keyboard_a && code <= raw_keyboard_z)
		{
			return glfwGetKey( code - raw_keyboard_a + 'a') == GLFW_PRESS;
		}
		else if(code == raw_keyboard_tilde)
		{
			return glfwGetKey( '`' ) == GLFW_PRESS;
		}
		else if(code == raw_keyboard_minus)
		{
			return glfwGetKey( '-' ) == GLFW_PRESS;
		}
		else if(code == raw_keyboard_equals)
		{
			return glfwGetKey( '=' ) == GLFW_PRESS;
		}
		else if(code >= raw_keyboard_0 && code <= raw_keyboard_9)
		{
			return glfwGetKey(code - raw_keyboard_0 + '0') == GLFW_PRESS;
		}
		else if(code >= raw_keyboard_leftsquare && code <= raw_keyboard_space)
		{
			switch(code)
			{
			case raw_keyboard_leftsquare: return glfwGetKey( '[' ) == GLFW_PRESS;
			case raw_keyboard_rightsquare: return glfwGetKey( ']' ) == GLFW_PRESS;
			case raw_keyboard_forwardslash: return glfwGetKey( '\\' ) == GLFW_PRESS;
			case raw_keyboard_colon: return glfwGetKey( ':' ) == GLFW_PRESS;
			case raw_keyboard_quote: return glfwGetKey( '\'' ) == GLFW_PRESS;
			case raw_keyboard_comma: return glfwGetKey( ',' ) == GLFW_PRESS;
			case raw_keyboard_period: return glfwGetKey( '.' ) == GLFW_PRESS;
			case raw_keyboard_backslash: return glfwGetKey( '/' ) == GLFW_PRESS;
			case raw_keyboard_space: return glfwGetKey( GLFW_KEY_SPACE ) == GLFW_PRESS;
			}
		}
		else if(code >= raw_keyboard_esc && code <= raw_keyboard_menu)
		{
			return glfwGetKey( code - raw_keyboard_esc + GLFW_KEY_ESC )==GLFW_PRESS;
		}
		else if(code >= raw_gamepad_button_0 && code <= raw_gamepad_button_15)
		{
			return _joybuttons[code - raw_gamepad_button_0] == GLFW_PRESS;
		}
		else if (code == raw_mouse_button_left)
		{
			return glfwGetMouseButton(GLFW_MOUSE_BUTTON_LEFT) == GLFW_PRESS;
		}
		else if (code == raw_mouse_button_middle)
		{
			return glfwGetMouseButton(GLFW_MOUSE_BUTTON_MIDDLE) == GLFW_PRESS;
		}
		else if (code == raw_mouse_button_right)
		{
			return glfwGetMouseButton(GLFW_MOUSE_BUTTON_RIGHT) == GLFW_PRESS;
		}
		return false;
	}

	//bool InputObject::IsKeyJustDown(RawInputCode code)
	//{
	//	if(_codes.find(code) != _codes.end())
	//	{
	//		return _codes[code] == button_just_down;
	//	}
	//	return false;
	//}

	bool InputObject::IsKeyUp(RawInputCode code)
	{
		return !IsKeyDown(code);
	}

	//bool InputObject::IsKeyJustUp(RawInputCode code)
	//{
	//	if(_codes.find(code) != _codes.end())
	//	{
	//		return _codes[code] == button_just_up;
	//	}
	//	return false;
	//}

	//bool InputObject::HasAxis(RawInputCode code)
	//{
	//	return (_axes.find(code) != _axes.end());
	//}

	float InputObject::GetAxis(RawInputCode code)
	{
		if(code == raw_mouse_axis_x) return (float)_mousex;
		else if(code == raw_mouse_axis_y) return (float)_mousey;
		else if(code == raw_mouse_axis_scroll) return (float)_mousewheel;
		else if(code >= raw_gamepad_axis0 && code <= raw_gamepad_axis7) return _joyaxes[code-raw_gamepad_axis0];
		return 0.0f;
	}

	//void InputObject::Handle(RawInputCode code)
	//{
	//	if(_codes.find(code) != _codes.end())
	//	{
	//		_handledCodes[code] = _codes[code];
	//		_codes.erase(code);
	//	}
	//	else if(_axes.find(code) != _axes.end())
	//	{
	//		_handledAxes[code] = _axes[code];
	//		_axes.erase(code);
	//	}
	//}

}}