#ifndef __BASECODE_SYSTEM_MODULEMANAGER_H__
#define __BASECODE_SYSTEM_MODULEMANAGER_H__

#include <list>

#include "IModule.h"
#include "IResolvable.h"

namespace basecode { namespace Game {

	class ModuleManager : public System::IResolvable
	{
	private:

		IModule * _inputModule;
		IModule * _renderModule;

		std::list<IModule *> _modules;
		std::list<IModule *> _modulesReverse;
	public:

		void AddModule(IModule * module);
		void RemoveModule(IModule * module);

		void Init();
		void HandleInput(Input::InputObject * inputObject);
		void RunLogic();
		void Render();
		void Shutdown();
	};

}}

#endif  __BASECODE_SYSTEM_MODULEMANAGER_H__