// Program:  Physics.h - 3D Physics Library
// Language: C++
// Author:   Daniel Kennedy (Syn9)
//
// Copyright (c) 2010-2013
// ____________________________________________________________________________
#ifndef __BASECODE_PHYSICS_H__
#define __BASECODE_PHYSICS_H__

#include <GL/glm/glm.hpp>
#include <GL/glm/gtc/matrix_transform.hpp>
#include <GL/glm/gtx/transform.hpp>

#include <GL/glew.h>
#include <GL/glfw.h>
#include "Math.h"
#include "Color.h"
#include <vector>
#include "Hull.h"

namespace basecode { namespace Physics {

		// ******************** Physics_Object.cpp ***************************
		
		using namespace basecode::Math;

		class PhysicsObject
		{
		public:
			Matrix	orientation;
			Hull	hull;
			Color	color;
			vec3f	velocity;
			bool	split;
			float	splitTime;

			float	mass, invMass;

			// State
			vec3f	position;
			vec3f	linearMomentum;

			// Derived variables
			vec3f	linearVelocity;

			vec3f	position_last;
			vec3f	force;

			glm::mat4 MVP;			

			PhysicsObject();
			void convert(vec3f P, vec3f &V);
			void setMass(float m);
			void update(double dt);
		};

		class VolumePlane
		{
		public:
			vec3f normal;
			vec3f center;
			std::vector<vec3f> vertices;

			VolumePlane();
		};

		class Volume
		{
		public:
			std::vector<VolumePlane> planeList;
			std::vector<vec3f> vertices;
			vec3f center;
			std::vector<unsigned int> binList;

			Volume();
			void addPlane(std::vector<vec3f> verts);
			void clear();
			bool isInside(vec3f v0);
			bool isInside(vec3f v0, float r0);
			void findCenter();
		};

	}
}

#endif __BASECODE_PHYSICS_H__
