// Program:  Physics_Iterator.cpp - 3D Physics Library - Collision Iterator Routines
// Language: C++
// Author:   Daniel Kennedy (Syn9)
//
// Copyright (c) 2010
// ____________________________________________________________________________
#include "Physics.h"


namespace basecode
{
	using namespace Physics;

	Physics::CollisionInstance::CollisionInstance()
	{
		init();
	}


	void Physics::CollisionInstance::init()
	{
		position.set(0,0,0);
		penetrationDistance.set(0, 0, 0);
	}


	Physics::Iterator::Iterator()
	{
		objectList.clear();
		containerList.clear();
	}


	void Physics::Iterator::addContainer(Container* c)
	{
		containerList.push_back(c);
	}

	
	void Physics::Iterator::addObject(PhysicsObject* po)
	{
		objectList.push_back(po);
	}
	
	
	void Physics::Iterator::addObject(CollisionSphere* cs)
	{
		addObject((PhysicsObject*)cs);
	}


	void Physics::Iterator::addObject(CollisionBox* cb)
	{
		addObject((PhysicsObject*)cb);
	}


	/*
	void Physics::Iterator::compileContainers()
	{
		// for each container, see if it shares a wall with another container, if so, set wall to open
		
		CollisionPlane planeA, planeB;

		int num_matches;

		for (unsigned int a = 0; a < containerList.size(); a++)
			for (unsigned int b = a + 1; b < containerList.size(); b++)
				for (unsigned int pA = 0; pA < containerList[a]->collisionBox.planeList.size(); pA++)
					for (unsigned int pB = 0; pB < containerList[b]->collisionBox.planeList.size(); pB++)
					{
						planeA = containerList[a]->collisionBox.planeList[pA];
						planeB = containerList[b]->collisionBox.planeList[pB];

						if (planeA.center == planeB.center)
							if (planeA.max_vertices == planeB.max_vertices)
							{
								num_matches = 0;
								for (unsigned int vA = 0; vA < planeA.max_vertices; vA++)
									for (unsigned int vB = 0; vB < planeB.max_vertices; vB++)
										if (planeA.vertices[vA] == planeB.vertices[vB])
										{
											num_matches++;
											break;
										}

								if (num_matches == planeA.max_vertices)
								{
									containerList[a]->collisionBox.planeList[pA].wallType = OPEN;
									containerList[b]->collisionBox.planeList[pB].wallType = OPEN;
									containerList[a]->connectionList.push_back(b);
									containerList[b]->connectionList.push_back(a);
								}

							}

					}

	}
	*/


	void Physics::Iterator::unload()
	{
		/*for (unsigned int c = 0; c < containerList.size(); c++)
			delete(containerList[c]);

		for (unsigned int p = 0; p < objectList.size(); p++)
			delete(objectList[p]);*/

		objectList.clear();
		containerList.clear();
	}


	void Physics::Iterator::update()
	{
		// do not allow updates for an empty world
		if (containerList.size() == 0) return;
		
		vec3f position, gravity;
		int gcounter;

		// update the containers
		//for (unsigned int i = 0; i < containerList.size(); i++)
		//	containerList[i]->collisionBox.updateMatrix();

		// call the update routine for every object in the scene
		for (unsigned int i = 0; i < objectList.size(); i++)
		{
			// update the object's position
			//objectList[i]->update();

			// figure out which rooms the object is in
			// the right thing to do would be create a list of all attached containers to the last list, and only check those
			objectList[i]->containerIDs.clear();
			for (unsigned int c = 0; c < containerList.size(); c++)
				if (containerList[c]->collisionBox.isInside((Volume*)objectList[i]))
					objectList[i]->containerIDs.push_back(c);

			if (objectList[i]->containerIDs.size() > 0)
			{
				//gravity = vec3f(0, 0, 0);
				gravity = objectList[i]->gravity;
				gcounter = 1;
				for (unsigned int c = 0; c < objectList[i]->containerIDs.size(); c++)
					if (containerList[objectList[i]->containerIDs[c]]->collisionBox.gravity.magnitude() == 1)
					{
						gravity += containerList[objectList[i]->containerIDs[c]]->collisionBox.gravity.multiply(containerList[objectList[i]->containerIDs[c]]->collisionBox.matrix);
						gcounter++;
					}
				

				gravity /= (float)gcounter;
				objectList[i]->applyForce(gravity * .02f);
				objectList[i]->gravity = gravity;

				
			}

			// update the object's position
			objectList[i]->update();
		}


		CollisionBox* box;
		CollisionInstance ci;
		CollisionSphere* cs;
		CollisionSphere* cs2;
		CollisionBox* cb;

		// wall center, wall normal
		vec3f wc, wn;
		vec3f testPoint;

		vec3f vNormal, vTangent, fNormal, fTangent;

		// used for checking impact on corners
		vec3f pA, pB, vN, vTP;
		unsigned int e, e2;
		bool pass;

		float dt, dt2;

		// used for sphere to sphere collision
		float minDist;
		float ratio;
		vec3f vBA;
		float vBAmag;
		vec3f lvBA;
		float lvDot, lv2Dot;
		vec3f wnBA, wnAB;

		float elasticity = .175f;
		float slidingFriction = 0.1f;//.01f;

		// used for collision box rotation
		vec3f linVelocity, anVelocity, testPointRot, combinedVelocity;
		vec3f vAO;
		vec3f linForce, anForce, combinedForce;
		float vAOmag;
		
		int counter = 0;

		do
		{
			collisionList.clear();

			// create a list of all the current collision instances
			for (unsigned int o = 0; o < objectList.size(); o++)
			{
				if (((Volume*)objectList[o])->shape == BOX)
				{
					cb = (CollisionBox*)objectList[o];

					// compare each object in the list to each wall of each room it is inside
					for (unsigned int c = 0; c < objectList[o]->containerIDs.size(); c++)
					{
						box = &containerList[objectList[o]->containerIDs[c]]->collisionBox;

						for (unsigned int w = 0; w < box->planeList.size(); w++)
						{
							// do not check walls that are open
							if (box->planeList[w].wallType == OPEN) continue;

							wc = box->planeList[w].center;
							wn = box->planeList[w].normal;

							wn += wc;

							// not necessary atm
							//wc = wc.multiply(box->matrix);
							//wn = wn.multiply(box->matrix);

							wn -= wc;

							for (unsigned int boxVertex = 0; boxVertex < cb->vertices.size(); boxVertex++)
							{
								testPoint = cb->vertices[boxVertex];
								testPoint = testPoint.multiply(cb->matrix);

								testPoint -= wc;

								dt = wn.dot(testPoint);
								if (dt < 0)
								{
									// add to collision list
									ci.init();
									ci.penetrationDistance = wn * dt * 1.1f;
									ci.position = testPoint + wc - ci.penetrationDistance * 1.1f;

									/*if (!box->isInside(ci.position))
									{
										// point is not inside this container, but does intersect this wall
										// perform distance determination to sphere center to find out if an actual collision occured

										pass = true;

										// for each wall of the plane, dot product between wall vector and vector from wall base to sphere position
										// determine the sphere's position projection onto the wall, determine if distance from that to sphere is < radius
										// if so, collision occured, find penetration distance

										for (e = 0; e < box->planeList[w].max_vertices; e++)
										{
											e2 = e + 1;
											if (e2 == box->planeList[w].max_vertices) e2 = 0;

											pA = box->planeList[w].vertices[e];
											pB = box->planeList[w].vertices[e2];

											// probably not necessary
											//pA = pA.multiply(box->matrix);
											//pB = pB.multiply(box->matrix);

											vN = pB - pA;
											vN.normalize();

											vTP = cs->position - pA;
											
											dt2 = vN.dot(vTP);

											vN *= dt2;

											vTP = vN + pA - cs->position;

											if (vTP.magnitude() < cs->radius)
											{
												pass = false;
												ci.position = vN + pA;
												ci.penetrationDistance = vTP;
												ci.penetrationDistance.normalize();
												ci.penetrationDistance *= cs->radius;
												ci.penetrationDistance -= vTP;

												wn = vTP;
												wn.normalize();
												break;
											}								
										}

										if (pass) continue;
									}*/

									ci.volumeA = (Volume*)cb;
									ci.volumeB = (Volume*)box;


									vAO = cb->vertices[boxVertex];
									vAO = vec3f(0, 0, 0).multiply(cb->matrix) - vAO.multiply(cb->matrix);
									vAOmag = vAO.magnitude();
									vAO.normalize();
									
									linVelocity = cb->linearVelocity;

									anVelocity = cb->angularVelocity.cross(vAO * vAOmag);
									
									// determine actual rotation velocity at the point in contact
									//testPointRot = cb->vertices[boxVertex];
									//testPointRot = testPointRot.multiply(cb->matrixRot);

									// have to add wc back to testpoint
									//anVelocity = testPointRot - testPoint - wc;
																		
									//printf("cb:%s\nan:%s\n", cb->angularVelocity.c_str(), anVelocity.c_str());
									//printf("%f, %f\n", cb->angularVelocity.magnitude(), anVelocity.magnitude());
									
									combinedVelocity = linVelocity + anVelocity;


									// update linear motion

									vNormal = wn * wn.dot(combinedVelocity);
									vTangent = combinedVelocity - vNormal;

									combinedVelocity = vTangent * (1 - slidingFriction) - vNormal * elasticity;

									
									// determine angular velocity
									// find vector of test point to box origin
									

									linVelocity = vAO * vAO.dot(combinedVelocity);
									anVelocity = combinedVelocity - linVelocity;

									cb->linearVelocity = linVelocity;
									cb->angularMomentum = anVelocity.cross(vAO * vAOmag) * 10; // * mass
/*
									//cb->linearVelocity.set(0, 0, 0);
									//cb->angularMomentum.set(0, 0, 0);

									// determine force changes
									combinedForce = cb->force;
									//combinedForce -= cb->angularMomentum.cross(vAO * vAOmag);

									fNormal = wn * wn.dot(combinedForce);
									fTangent = combinedForce - fNormal;

									combinedForce = fTangent * (1 - slidingFriction) - fNormal;

									linForce = vAO * vAO.dot(combinedForce);
									anForce = combinedForce - linForce;

									cb->applyForce(linForce);
									//cb->applyTorque(anForce.cross(vAO * vAOmag));
									
									printf("linForce: %f\nanForce: %f\n", linForce.magnitude(), anForce.magnitude());
									
									// push back and update matrix
									*/

									cb->position -= ci.penetrationDistance;

									//cb->updateMatrix();
									cb->update();

									collisionList.push_back(ci);
								}
							}
						}
					}
				}


				if (((Volume*)objectList[o])->shape == SPHERE)
				{
					cs = (CollisionSphere*)objectList[o];

					// compare each object in the list to each wall of each room it is inside
					for (unsigned int c = 0; c < objectList[o]->containerIDs.size(); c++)
					{
						box = &containerList[objectList[o]->containerIDs[c]]->collisionBox;

						for (unsigned int w = 0; w < box->planeList.size(); w++)
						{
							// do not check walls that are open
							if (box->planeList[w].wallType == OPEN) continue;

							wc = box->planeList[w].center;
							wn = box->planeList[w].normal;

							wn += wc;

							// not necessary atm
							//wc = wc.multiply(box->matrix);
							//wn = wn.multiply(box->matrix);

							wn -= wc;

							testPoint = cs->position - wn * cs->radius - wc;

							dt = wn.dot(testPoint);
							if (dt < 0)
							{
								// add to collision list
								ci.init();
								ci.penetrationDistance = wn * dt;
								ci.position = testPoint + wc - ci.penetrationDistance * 1.1F;
								
								if (!box->isInside(ci.position))
								{
									// point is not inside this container, but does intersect this wall
									// perform distance determination to sphere center to find out if an actual collision occured

									pass = true;

									// for each wall of the plane, dot product between wall vector and vector from wall base to sphere position
									// determine the sphere's position projection onto the wall, determine if distance from that to sphere is < radius
									// if so, collision occured, find penetration distance

									for (e = 0; e < box->planeList[w].max_vertices; e++)
									{
										e2 = e + 1;
										if (e2 == box->planeList[w].max_vertices) e2 = 0;

										pA = box->planeList[w].vertices[e];
										pB = box->planeList[w].vertices[e2];

										// probably not necessary
										//pA = pA.multiply(box->matrix);
										//pB = pB.multiply(box->matrix);

										vN = pB - pA;
										vN.normalize();

										vTP = cs->position - pA;
										
										dt2 = vN.dot(vTP);

										vN *= dt2;

										vTP = vN + pA - cs->position;

										if (vTP.magnitude() < cs->radius)
										{
											pass = false;
											ci.position = vN + pA;
											ci.penetrationDistance = vTP;
											ci.penetrationDistance.normalize();
											ci.penetrationDistance *= cs->radius;
											ci.penetrationDistance -= vTP;

											wn = vTP;
											wn.normalize();
											break;
										}								
									}

									if (pass) continue;
								}

								ci.volumeA = (Volume*)cs;
								ci.volumeB = (Volume*)box;

								vNormal = wn * wn.dot(cs->linearVelocity);
								vTangent = cs->linearVelocity - vNormal;

								cs->linearVelocity = vTangent * (1 - slidingFriction) - vNormal * elasticity;
								cs->linearVelocity -= ci.penetrationDistance * elasticity;

								fNormal = wn * wn.dot(cs->force);
								fTangent = cs->force - fNormal;

								cs->force = fTangent * (1 - slidingFriction) + fNormal;// * elasticity;
								
								cs->position -= ci.penetrationDistance;
								cs->updateMatrix();

								collisionList.push_back(ci);
							}

						}
					}

					// perform sphere to sphere collision detection
					for (unsigned int o2 = o + 1; o2 < objectList.size(); o2++)
					{
						cs2 = (CollisionSphere*)objectList[o2];
						
						minDist = cs->radius + cs2->radius;

						vBA = cs->position - cs2->position;
						//wnBA = cs2->position - cs->position;
						//wnBA.normalize();
						//wnAB = wnBA * -1;

						if (vBA.x > minDist) continue;
						if (vBA.y > minDist) continue;
						if (vBA.z > minDist) continue;

						vBAmag = vBA.magnitude();

						wnAB = vBA * (1 / vBAmag);
						wnBA = wnAB * -1;


						if (vBAmag < minDist)
						{
							ci.init();
							ratio = vBAmag / minDist;
							ci.position = vBA;
							ci.position.normalize();
							ci.position *= cs->radius;
							ci.position += cs->position;

							ci.penetrationDistance = vBA;
							ci.penetrationDistance *= 1 - ratio;
							ci.penetrationDistance *= 1.1f;

							cs->position += ci.penetrationDistance;
							cs2->position -= ci.penetrationDistance;

							lvDot = wnBA.dot(cs->linearVelocity);
							lv2Dot = wnAB.dot(cs2->linearVelocity);

							if (lvDot > 0) // cs is moving toward cs2
							{
								vNormal = wnBA * lvDot;
								vTangent = cs->linearVelocity - vNormal;

								cs->linearVelocity = vTangent * (1 - slidingFriction); // rebound
								cs2->linearVelocity += vNormal * elasticity; // transfer normal velocity into cs2
								
								fNormal = wnBA * lvDot;
								fTangent = cs->force - fNormal;

								cs->force = fTangent * (1 - slidingFriction);
								cs2->force += vNormal * elasticity;
							}

							if (lv2Dot > 0) // cs2 is moving toward cs
							{
								vNormal = wnAB * lv2Dot;
								vTangent = cs2->linearVelocity - vNormal;

								cs2->linearVelocity = vTangent * (1 - slidingFriction); // rebound
								cs->linearVelocity += vNormal * elasticity; // transfer normal velocity into cs2
								
								fNormal = wnAB * lv2Dot;
								fTangent = cs2->force - fNormal;

								cs2->force = fTangent * (1 - slidingFriction);
								cs->force += vNormal * elasticity;
							}

							ci.volumeA = (Volume*)cs;
							ci.volumeB = (Volume*)cs2;

							cs->updateMatrix();
							cs2->updateMatrix();

							collisionList.push_back(ci);
						}

					}
				}
			}

			if (++counter > 10) printf("STUCK!\n");
		

		} while (collisionList.size() > 0 && counter < 4);


		// perform friction dampening
		for (unsigned int i = 0; i < objectList.size(); i++)
		{
			objectList[i]->force = objectList[i]->linearVelocity * -.01f;
			objectList[i]->torque = objectList[i]->angularMomentum * -.01f;
		}
		
	}


	void Physics::Iterator::update(unsigned int steps)
	{
		while (steps-- != 0) update();
	}

}
