// Program:  Physics_Object.cpp - 3D Physics Library - Object Routines
// Language: C++
// Author:   Daniel Kennedy (Syn9)
//
// Copyright (c) 2010
// ____________________________________________________________________________
#include "Physics.h"
#include "PhysicsSync.h"

namespace basecode { namespace Physics {

	using namespace basecode::Math;

	PhysicsObject::PhysicsObject()
	{
		split = false;
		splitTime = 0;
		mass = 1;
		invMass = 1 / mass;
	}

	void PhysicsObject::setMass(float m)
	{
		mass = m;
		invMass = 1 / m;
	}

	void PhysicsObject::convert(vec3f P, vec3f &V)
	{
		V = P * invMass;
	}

	// Euler Integrator
	void PhysicsObject::update(double dt)
	{
		vec3f dxdt = linearVelocity;
		vec3f dpdt = force;

		position_last = position;
		position += dxdt * (float)dt;
		position.z = 0;

		linearMomentum += dpdt * (float)dt;

		convert(linearMomentum, linearVelocity);
		force.set(0, 0, 0);

		glm::mat4 posMat = glm::translate(glm::mat4(1), glm::vec3(position.x, position.y, position.z));
		glm::mat4 orientMat = glm::mat4(1);
	
		for (int a = 0; a < 4; a++)
			for (int b = 0; b < 4; b++)
				orientMat[a][b] = orientation.data()[a * 4 + b];

		MVP = posMat * orientMat * glm::mat4(1);

	}

	Volume::Volume()
	{
	}

	VolumePlane::VolumePlane()
	{
	}

	void Volume::addPlane(std::vector<vec3f> verts)
	{
		VolumePlane vp;
		vec3f v0, v1;

		for (unsigned int i = 0; i < verts.size(); i++)
		{
			vp.center += verts[i];
		}
		vp.center /= (float)verts.size();

		v0 = verts[1] - verts[0];
		v1 = verts[2] - verts[0];
		
		vp.normal = v0.cross(v1);
		vp.normal.normalize();
		vp.vertices = verts;

		planeList.push_back(vp);
		findCenter();
	}

	void Volume::clear()
	{
		planeList.clear();
		vertices.clear();
		center = basecode::vec3f();
	}

	void Volume::findCenter()
	{
		center.set(0, 0, 0);

		for (unsigned int i = 0; i < planeList.size(); i++)
			center += planeList[i].center;

		center /= (float)planeList.size();
	}


	bool Volume::isInside(vec3f v0)
	{
		for (unsigned int p = 0; p < planeList.size(); p++)
		{
			if (planeList[p].normal.dot(v0 - planeList[p].center) < 0) return false;
		}
		return true;
	}


	bool Volume::isInside(vec3f v0, float r0)
	{
		for (unsigned int p = 0; p < planeList.size(); p++)
		{
			if (planeList[p].normal.dot(v0 - (planeList[p].center - planeList[p].normal * r0)) < 0) return false;	
		}
		return true;
	}

}}
