#include "PlayerObject.h"

PlayerObject::PlayerObject()
{
	shipType = PLAYER_LIGHT;
	remove = false;
}

void PlayerObject::collision(unsigned int obj, basecode::Math::vec3f pnt)
{
}

bool PlayerObject::garbage()
{
	return remove;
}

void PlayerObject::render()
{
}

void PlayerObject::render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix)
{
	glUseProgram(shaderID);

	glm::mat4 model = *projectionMatrix * *viewMatrix * po.MVP;

	glUniformMatrix4fv(matrixID, 1, GL_FALSE, &model[0][0]);

	glEnableVertexAttribArray(0);
	glBindBuffer(GL_ARRAY_BUFFER, po.hull.vertexBuffer);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)0);

	glEnableVertexAttribArray(1);
	glBindBuffer(GL_ARRAY_BUFFER, po.hull.colorBuffer);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (void*)0);

	glDrawArrays(GL_TRIANGLES, 0, po.hull.planes.size() * 3);
 
	glDisableVertexAttribArray(0);
	glDisableVertexAttribArray(1);
	
	/*glPushMatrix();

	glTranslatef(po.position.x, po.position.y, po.position.z);
	po.orientation.glMultMatrixf();

	glBegin(GL_TRIANGLES);

	basecode::Color c;
	basecode::vec3f n, v;
		
	for (unsigned int f = 0; f < po.hull.planes.size(); f++)
	{
		c = po.color;
		n = po.hull.planes[f].normal.multiply(po.orientation);
		c.scale(.5f + .5f * n.dot(1, 1, 1));
		c.glColor3f();

		glVertex3fv(&po.hull.planes[f].vertices[0].x);
		glVertex3fv(&po.hull.planes[f].vertices[1].x);
		glVertex3fv(&po.hull.planes[f].vertices[2].x);
	}

	glEnd();
	
	glPopMatrix();*/
}

basecode::Physics::PhysicsObject* PlayerObject::physics()
{
	return &po;
}


void PlayerObject::sync(ISyncObject & syncObject, double time)
{
	throw "need to implement Game Object sync method";
}

void PlayerObject::update(float interval)
{
	po.update(interval);
}