#ifndef __PLAYER_OBJECT_H__
#define __PLAYER_OBJECT_H__

#include <GL/glm/glm.hpp>
#include "ISyncObject.h"
#include "Physics.h"
#include "Game/IGameObject.h"


// Player Ship Types
#define PLAYER_LIGHT 0

class PlayerObject: public basecode::Game::IGameObject, public basecode::ISyncObject
{
private:
	basecode::Physics::PhysicsObject po;
	unsigned int modelid;
	unsigned int shipType;
	bool remove;

public:
	PlayerObject();

	void collision(unsigned int obj, basecode::Math::vec3f pnt);
	bool garbage();
	void render();
	void render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix);
	basecode::Physics::PhysicsObject* physics();
	void sync(ISyncObject & syncObject, double time);
	void update(float interval);
};

#endif __PLAYER_OBJECT_H__
