#include "TalonFiveGameInputMapping.h"
#include "TalonFiveModule.h"
#include "Resolver.h"
#include "TalonFiveConstants.h"
#include "Settings.h"
#include "SettingsGetValueT.h"
#include "Utility.h"
#define GLFW_DLL
#include <GL/glfw.h>
#include "GlfwConstants.h"
#include "TalonFiveGameInputMapping.h"
#include "Game/InputObject.h"

#include <math.h>
#include <string>
#include <fstream>


namespace TalonFive {

	void Module::Render_Background()
	{
		glUseProgram(bgShaderID);

		glActiveTexture(GL_TEXTURE0);
        glBindTexture(GL_TEXTURE_2D, bgTex);
        glUniform1i(bgTextureID, 0);

        glEnableVertexAttribArray(0);
        glBindBuffer(GL_ARRAY_BUFFER, bgVertexBuffer);
        glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)0);

		glEnableVertexAttribArray(1);
        glBindBuffer(GL_ARRAY_BUFFER, bgUVBuffer);
        glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, 0, (void*)0);

		glDepthMask(GL_FALSE);

        glDrawArrays(GL_TRIANGLES, 0, 6);
        glDisableVertexAttribArray(0);
		glDisableVertexAttribArray(1);

		
		//--------------------

		glUseProgram(starShaderID);

		glEnableVertexAttribArray(0);
		glBindBuffer(GL_ARRAY_BUFFER, starVertexBuffer);
		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)0);

		glEnableVertexAttribArray(1);
		glBindBuffer(GL_ARRAY_BUFFER, starColorBuffer);
		glVertexAttribPointer(1, 4, GL_FLOAT, GL_FALSE, 0, (void*)0);

		//glUniform1f(timeID, (float)basecode::rnd() * .3f );

		glEnable(GL_BLEND);
		glDrawArrays(GL_TRIANGLES, 0, starList.size() * 3 * 24);
		glDisable(GL_BLEND);
 
		glDisableVertexAttribArray(0);
		glDisableVertexAttribArray(1);


		glDepthMask(GL_TRUE);
		/*		
		
		int y0 = yres / 2 - xres / 2;
		int y1 = y0 + xres;
		
		glBegin(GL_TRIANGLES);
		
		basecode::Color c;
		basecode::Math::vec2f v;

		float r = .5f;

		for (unsigned int i = 0; i < starList.size(); i++)
		{
			c = starList[i].c;
			c.scale(.7f + .3f * basecode::rnd());

			for (int j = 0; j < 24; j++)
			{
				c.glColor4f();
				glVertex2fv(&starList[i].position.x);
				glColor4f(c.r, c.g, c.b, 0);
				glVertex2f(starList[i].position.x + (1 + i % 5) * r * cos(3.14159f * 2 * j / 12.0f), starList[i].position.y + (1 + i % 5) * r * sin(3.14159f * 2 * j / 12.0f));
				glVertex2f(starList[i].position.x + (1 + i % 5) * r * cos(3.14159f * 2 * (j + 1) / 12.0f), starList[i].position.y + (1 + i % 5) * r * sin(3.14159f * 2 * (j + 1) / 12.0f));
			}
		}

		glEnd();

		*/
	}

	void Module::Render_HUD()
	{
		int xres = GET_SETTING(basecode::Game::Glfw::resx, int);
		int yres = GET_SETTING(basecode::Game::Glfw::resy, int);
		
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();

		glViewport(0, 0, xres, yres);
		gluOrtho2D(0, xres, yres, 0);
				
		glMatrixMode(GL_MODELVIEW );
		glLoadIdentity();
		
		glDisable(GL_DEPTH_TEST);
		glDepthMask(GL_FALSE);

		basecode::Color white = basecode::Color(1,1,1,1);
		std::wstring ad = font.prep(L"Active Debug: (" + wstr(ad_x.value()) + L", " + wstr(ad_y.value()) + L", " + wstr(ad_z.value()) + L")");
		font.print(10, 10, ad, white);
		font.print(10, 30, font.prep(L"fps: " + wstr(fps.value())), white);
		font.print(10, 50, font.prep(L"Mouse: " + wstr(mouse.position.c_str())), white);

		glEnable(GL_DEPTH_TEST);
		glDepthMask(GL_TRUE);


		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		
	}
	
	void Module::Render()
	{
		int xres = GET_SETTING(basecode::Game::Glfw::resx, int);
		int yres = GET_SETTING(basecode::Game::Glfw::resy, int);
		
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

		Render_Background();

		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);

		viewMatrix = glm::lookAt(glm::vec3(objList[0]->physics()->position.x, objList[0]->physics()->position.y, 80), glm::vec3(objList[0]->physics()->position.x, objList[0]->physics()->position.y, -1), glm::vec3(0, 1, 0));


		for (unsigned int a = 0; a < objList.size(); a++) objList[a]->render(fieldShaderID, matrixID, &projectionMatrix, &viewMatrix);
		
		glFlush();
		glfwSwapBuffers();
	
		
		return;

		glLoadIdentity();		
		glPushMatrix();

		cameraTarget = objList[0]->physics()->position * -1;
		camera += (cameraTarget - camera);// * .5f;// timer.delta() / .25f;

		glTranslatef(camera.x, camera.y, -150);

		//glRotatef(ad_x.value() * 100, 0, 1, 0);
		//glRotatef(ad_y.value() * 100, 1, 0, 0);

		// old mouse code
		//----------------
		/*int viewport[4];
		double modelview[16];
		double projection[16];
		float winx, winy;
		basecode::Math::vec3f mp;
		
		glGetDoublev(GL_MODELVIEW_MATRIX, modelview);
		glGetIntegerv(GL_VIEWPORT, viewport);
		glGetDoublev(GL_PROJECTION_MATRIX, projection);

		winx = (float)mouse.position.x;
		winy = (float)viewport[3] - mouse.position.y;
			
		gluUnProject(winx, winy, 0, modelview, projection, viewport, &mouse.posxs, &mouse.posys, &mouse.poszs);
		gluUnProject(winx, winy, 1, modelview, projection, viewport, &mouse.posxe, &mouse.posye, &mouse.posze);

		mp.set((float)mouse.posxe - (float)mouse.posxs, (float)mouse.posye - (float)mouse.posys, (float)mouse.posze - (float)mouse.poszs);
		mp.normalize();

		basecode::vec3f mv;
		mp *= mp.dot(objList[0]->physics()->position - basecode::vec3f((float)mouse.posxs, (float)mouse.posys, (float)mouse.poszs));
		mv.x = (float)mouse.posxs + mp.x;
		mv.y = (float)mouse.posys + mp.y;
		mv.z = (float)mouse.poszs + mp.z;

		glBegin(GL_LINES);
		glColor3f(.5f, 0, 0);
		glVertex3fv(&(objList[0]->physics()->position.x));
		glVertex3fv(&mv.x);
		glEnd();*/

		//Render_Object(&poA);
		//Render_Object(&poB);

		for (unsigned int a = 0; a < objList.size(); a++)
		{
			//objList[a].color.glColor3f();
			//objList[a].orientation.rotate(.5f + ad_x.value(), .5f + ad_y.value(), 0);
			//Render_Object(&objList[a]);
			objList[a]->render();
		}

		//Render_Object(player);

		/*glBegin(GL_LINES);
		for (unsigned int v = 0; v < volumeList.size(); v++)
		{
			glColor4f(1, 1, 1, 1);
			if (asel == v) glColor4f(1, 0, 0, 1);

			for (unsigned int p = 0; p < volumeList[v].planeList.size(); p++)
			{
				for (unsigned int i = 0; i < volumeList[v].planeList[p].vertices.size(); i++)
				{
					glVertex3fv(&volumeList[v].planeList[p].vertices[i].x);
					glVertex3fv(&volumeList[v].planeList[p].vertices[(i + 1) % volumeList[v].planeList[p].vertices.size()].x);
				}
			}
		}
		glEnd();
*/
		glPushMatrix();
		basecode::vec3f position = objList[0]->physics()->position;
		float theta, mag;
		
		glTranslatef(position.x, position.y, position.z);

			glBegin(GL_TRIANGLES);
			
				float w = -.003f;
				glColor4f(0, 0, 1, 1);

				glVertex3f(0, 0, 0);

				glColor4f(1, .55f, .55f, 0);

				theta = atan2(shipForce.y, shipForce.x);
				mag = shipForce.magnitude() * w;

				glVertex2f(mag * cos(theta - 0.27f), mag * sin(theta - 0.27f));

				glVertex2f(mag * cos(theta + 0.27f), mag * sin(theta + 0.27f));
				
			glEnd();

		glPopMatrix();

		glPopMatrix();

		Render_HUD();

		glFlush();
		glfwSwapBuffers();
	
	}

	void Module::Render_Object(basecode::Physics::PhysicsObject* po)
	{
		

		////glBegin(GL_LINES);
		//glBegin(GL_TRIANGLES);

		////glColor3f(1, 1, 1);
		//basecode::Color c;
		//basecode::vec3f n, v;
		//
		//for (unsigned int f = 0; f < hull->planes.size(); f++)
		//{
		//	/*glVertex3fv(&hull->planes[f].vertices[0].x);
		//	glVertex3fv(&hull->planes[f].vertices[1].x);

		//	glVertex3fv(&hull->planes[f].vertices[1].x);
		//	glVertex3fv(&hull->planes[f].vertices[2].x);

		//	glVertex3fv(&hull->planes[f].vertices[2].x);
		//	glVertex3fv(&hull->planes[f].vertices[0].x);*/

		//	//glNormal3fv(&hull->planes[f].normal.x);

		//	c.set(.15f);
		//	c = po->color;
		//	n = hull->planes[f].normal.multiply(po->orientation);
		//	c.scale(n.dot(1, 1, 1));
		//	c.glColor3f();

		//	glVertex3fv(&hull->planes[f].vertices[0].x);
		//	glVertex3fv(&hull->planes[f].vertices[1].x);
		//	glVertex3fv(&hull->planes[f].vertices[2].x);
		//}

		//glEnd();
		//glPopMatrix();

		//glPopMatrix();
	}
}
