#include "Resolver.h"


using namespace std;

namespace basecode { namespace System {

	Resolver * Resolver::instance=NULL;

	Resolver * Resolver::GetInstance()
	{
		if(instance == NULL)instance = new Resolver();

		return instance;
	}
	
	error_t Resolver::Register(const type_info& registerType, IResolvable * object)
	{
		if(GetInstance()->lookup.count(registerType.hash_code()) !=0) return error_already_defined;
		GetInstance()->lookup[registerType.hash_code()] = object;
		return error_none;
	}

	error_t Resolver::RegisterLazy(const type_info& registerType, IResolvable * (*createObject)())
	{
		Resolver * instance = GetInstance();
		if(instance->createLazyFunc.count(registerType.hash_code()) !=0) return error_already_defined;
		instance->createLazyFunc[registerType.hash_code()] = createObject;
		return error_none;
	}

	error_t Resolver::RegisterInstancePer(const type_info& registerType, IResolvable * (*createObject)())
	{
		Resolver * instance = GetInstance();
		if(instance->createInstanceFunc.count(registerType.hash_code()) !=0) return error_already_defined;
		instance->createInstanceFunc[registerType.hash_code()] = createObject;
		return error_none;
	}

	void Resolver::Deregister(const type_info& registerType)
	{
		Resolver * r = GetInstance();
		size_t hashCode = registerType.hash_code();
		if(r->lookup.count(hashCode) !=0){
			r->lookup.erase(hashCode);
		}
	}

	IResolvable * Resolver::Resolve(const type_info& objectType) throw()
	{
		Resolver * r = GetInstance();
		size_t hashCode = objectType.hash_code();
		if(r->lookup.count(hashCode) != 0) return r->lookup[hashCode];
		if(r->createLazyFunc.count(hashCode) != 0)
		{
			r->lookup[hashCode] = r->createLazyFunc[hashCode]();
			return r->lookup[hashCode];
		}
		if(r->createInstanceFunc.count(hashCode) !=0) return r->createInstanceFunc[hashCode]();
		
		throw error_could_not_resolve_type;
	}

	void Resolver::AddRegistry(IResolveRegistry * registry)
	{
		registry->AddRegistrations();
	}

}}