#include "TalonFiveModule.h"

namespace TalonFive {

	void Module::Run()
	{
		// force 30hz frame rate.
		while (glfwGetTime() - frameTime < .034f) {  } 
		frameTime = glfwGetTime();

		fps.update();
		timer.update();

		ad_x.update();
		ad_y.update();
		ad_z.update();
		
		shipForce = objList[0]->physics()->force;

		while (ptimer.ready())
		{
			for (unsigned int a = 0; a < objList.size(); a++)
			{
				objList[a]->update(ptimer.min_interval);
			}
		}

		bool remove;
		for (unsigned int i = 0; i < objList.size(); i++)
		{
			remove = false;
			if (tetherBeam.tetherA)
			{
				if (objList[i] == tetherBeam.tetherA && ((TetherObject*)tetherBeam.tetherA)->isAttached() && ((TetherObject*)tetherBeam.tetherA)->attachedTo()->garbage())
				{
					remove = true;
					((TetherObject*)tetherBeam.tetherA)->setRemove();
					tetherBeam.disable();
				}
			}
		
			for (unsigned int t = 0; t < tetherList.size(); t++)
			{
				if (objList[i] == tetherList[t].tetherA && ((TetherObject*)tetherList[t].tetherA)->isAttached())
					if (((TetherObject*)tetherList[t].tetherA)->attachedTo()->garbage())
					{
						remove = true;
						((TetherObject*)tetherList[t].tetherA)->setRemove();
						((TetherObject*)tetherList[t].tetherB)->setRemove();
						tetherList.erase(tetherList.begin() + t);
						t--;
						continue;
					}
				
				if (objList[i] == tetherList[t].tetherB && ((TetherObject*)tetherList[t].tetherB)->isAttached())
					if (((TetherObject*)tetherList[t].tetherB)->attachedTo()->garbage())
					{
						remove = true;
						((TetherObject*)tetherList[t].tetherA)->setRemove();
						((TetherObject*)tetherList[t].tetherB)->setRemove();
						tetherList.erase(tetherList.begin() + t);
						t--;
						continue;
					}
			}

			if (remove)
			{
				objList.erase(objList.begin() + i);
				i--;
			}
		}

		for (unsigned int i = 0; i < objList.size(); i++)
		{
			remove = false;
			if (objList[i]->garbage()) remove = true;

			if (remove)
			{
				objList.erase(objList.begin() + i);
				i--;
			}
		}

		float tetherlen;
		if (tetherBeam.tetherA)
		{
			tetherlen = ((TetherObject*)tetherBeam.tetherA)->length();
			if (tetherlen > 80)
			{
				for (unsigned int i = 0; i < objList.size(); i++)
				{
					if (objList[i] == tetherBeam.tetherA)
					{
						objList.erase(objList.begin() + i);
						break;
					}
				}
				tetherBeam.disable();
			}
		}
		
		for (unsigned int t = 0; t < tetherList.size(); t++)
		{
			tetherlen = ((TetherObject*)tetherList[t].tetherA)->length();

			if (tetherlen > 80 || tetherList[t].expiration() < timer.time() || (tetherlen < 15 && ((TetherObject*)tetherList[t].tetherA)->isAttached()))
			{
				for (unsigned int i = 0; i < objList.size(); i++)
				{
					if (objList[i] == tetherList[t].tetherA)
					{
						objList.erase(objList.begin() + i);
						i--;
					}
					if (objList[i] == tetherList[t].tetherB)
					{
						objList.erase(objList.begin() + i);
						i--;
					}
				}
				tetherList[t].disable();
				tetherList.erase(tetherList.begin() + t);
				t--;
			}
		}

		// reset asteroid colors
		objList[0]->physics()->color.set(1);
		for (unsigned int a = 1; a < objList.size(); a++)
		{
			objList[a]->physics()->color.set(.2f, .2f, .2f);
		}

		
		// fill volume bins
		for (unsigned int v = 0; v < volumeList.size(); v++)
		{
			volumeList[v].binList.clear();
			for (unsigned int a = 0; a < objList.size(); a++)
			{
				if (volumeList[v].isInside(objList[a]->physics()->position, objList[a]->physics()->hull.radius)) volumeList[v].binList.push_back(a);
			}
		}

		// perform far search
		nearList.clear();
		unsigned int bsize, low, high;
		for (unsigned int v = 0; v < volumeList.size(); v++)
		{
			bsize = volumeList[v].binList.size();
			if (bsize == 0) continue;
			for (unsigned int a = 0; a < bsize - 1; a++)
			{
				for (unsigned int b = a + 1; b < bsize; b++)
				{
					if ((objList[volumeList[v].binList[a]]->physics()->position - objList[volumeList[v].binList[b]]->physics()->position).magnitude2() <= pow(objList[volumeList[v].binList[a]]->physics()->hull.radius + objList[volumeList[v].binList[b]]->physics()->hull.radius, 2.0f))
					{
						low = volumeList[v].binList[a];
						high = volumeList[v].binList[b];
						if (low > high)
						{
							low = high;
							high = volumeList[v].binList[a];
						}
						nearList.insert(std::make_pair(low, high));
					}
				}
			}
		}

		// perform near search
		bool pass;
		float dist;
		unsigned int A, B;
		basecode::vec3f n;
		basecode::vec3f p;
		basecode::vec3f relative;
		basecode::vec3f collisionPointA, collisionPointB;
		basecode::Hull *hullA, *hullB;
		bool collide;

		for (std::set<std::pair<unsigned int, unsigned int>>::iterator it = nearList.begin(); it != nearList.end(); ++it)
		{
			A = (*it).first;
			B = (*it).second;
			
			collide = true;
			
			relative = objList[A]->physics()->position - objList[B]->physics()->position;
			relative.normalize();
			float dot;

			dot = relative.dot(objList[A]->physics()->velocity - objList[B]->physics()->velocity);
			if (dot > 0) continue;
			
			hullA = &objList[A]->physics()->hull;
			hullB = &objList[B]->physics()->hull;

			//objList[A].color.set(0, 1, 0);
			//objList[B].color.set(0, 1, 0);

			// A face, B point
			for (unsigned int f = 0; f < hullA->planes.size(); f++)
			{
				n = hullA->planes[f].normal;
				n = n.multiply(objList[A]->physics()->orientation);
				relative = objList[B]->physics()->position - objList[A]->physics()->position - hullA->planes[f].vertices[0].multiply(objList[A]->physics()->orientation);

				pass = true;
				for (unsigned int v = 0; v < hullB->vertices.size(); v++)
				{
					p = hullB->vertices[v];
					p = p.multiply(objList[B]->physics()->orientation);
					p += relative;

					dist = n.dot(p);
					if (dist < 0)
					{
						collisionPointA = p + hullA->planes[f].vertices[0].multiply(objList[A]->physics()->orientation);
						collisionPointB = hullB->vertices[v];		
						pass = false;
						break;
					}
				}
			
				if (pass)
				{
					collide = false;
					break;
				}
			}

			if (!collide) continue;

			// B face, A point
			for (unsigned int f = 0; f < hullB->planes.size(); f++)
			{
				n = hullB->planes[f].normal;
				n = n.multiply(objList[B]->physics()->orientation);
				relative = objList[A]->physics()->position - objList[B]->physics()->position - hullB->planes[f].vertices[0].multiply(objList[B]->physics()->orientation);

				pass = true;
				for (unsigned int v = 0; v < hullA->vertices.size(); v++)
				{
					p = hullA->vertices[v];
					p = p.multiply(objList[A]->physics()->orientation);
					p += relative;

					dist = n.dot(p);
					if (dist < 0)
					{
						pass = false;
						break;
					}
				}
			
				if (pass)
				{
					collide = false;
					break;
				}
			}

			if (!collide) continue;

			basecode::vec3f e, d;
			for (unsigned int a = 0; a < hullA->edges.size(); a++)
			{
				e = hullA->vertices[hullA->edges[a].y].multiply(objList[A]->physics()->orientation) - hullA->vertices[hullA->edges[a].x].multiply(objList[A]->physics()->orientation);
				relative = objList[B]->physics()->position - objList[A]->physics()->position - hullA->vertices[hullA->edges[a].x].multiply(objList[A]->physics()->orientation);

				for (unsigned int b = 0; b < hullB->edges.size(); b++)
				{
					d = hullB->vertices[hullB->edges[b].y].multiply(objList[B]->physics()->orientation) - hullB->vertices[hullB->edges[b].x].multiply(objList[B]->physics()->orientation);
					n = e.cross(d);

					if (n.magnitude() < .001f)
					{
						d = hullB->vertices[hullB->edges[b].x].multiply(objList[B]->physics()->orientation);
						d += relative;
						n = e.cross(d);

						//if (n.magnitude() < .001f) printf("edges parallel %d %d\n", a, b);
						if (n.magnitude() < .001f) break;
					}
					
					pass = true;
					for (unsigned int v = 0; v < hullB->vertices.size(); v++)
					{
						p = hullB->vertices[v].multiply(objList[B]->physics()->orientation);
						p += relative;

						dist = n.dot(p);
						if (dist < 0)
						{
							pass = false;
							break;
						}
					}
					if (pass)
					{
						for (unsigned int v = 0; v < hullA->vertices.size(); v++)
						{
							p = hullA->vertices[v].multiply(objList[A]->physics()->orientation);
							p -= hullA->vertices[hullA->edges[a].x].multiply(objList[A]->physics()->orientation);

							dist = n.dot(p);
							if (dist > 0)
							{
								pass = false;
								break;
							}
						}

						if (pass)
						{
							collide = false;
							break;
						}
					}
				}
				if (!collide) break;
			}

			if (!collide) continue;

			objList[A]->physics()->color.set(1, 0, 0);
			objList[B]->physics()->color.set(1, 0, 0);

			relative = objList[A]->physics()->position - objList[B]->physics()->position;
			relative.normalize();

			dot = relative.dot(objList[A]->physics()->linearMomentum);
			if (dot < 0 && objList[B]->physics()->hull.vertices.size() > 1)
			{
				objList[A]->physics()->linearMomentum -= relative * dot * 2;
				objList[A]->physics()->linearMomentum *= .5f;
				objList[A]->physics()->position = objList[A]->physics()->position_last;
				
				objList[A]->collision(B, collisionPointA);
				//if (objList[A].velocity.magnitude2() > 1.5f && objList[A].splitTime < timer.time() && objList[A].hull.minRadius > 4) objList[A].split = true;
			}

			dot = relative.dot(objList[B]->physics()->linearMomentum);
			if (dot > 0)
			{
				objList[B]->physics()->linearMomentum -= relative * dot * 2;
				objList[B]->physics()->linearMomentum *= .5f;
				objList[B]->physics()->position = objList[B]->physics()->position_last;

				objList[B]->collision(A, collisionPointB);
				//if (objList[B].velocity.magnitude2() > 1.5f && objList[B].splitTime < timer.time() && objList[B].hull.minRadius > 4) objList[B].split = true;
			}
		}

		// model split
		//basecode::Model model, modelA, modelB;
		//basecode::Hull *hull;
		//basecode::Math::vec3f fc;
		//basecode::Matrix m;
		//unsigned int asize = objList.size();
		//for (unsigned int a = 0; a < asize; a++)
		//{
		//	if (!objList[a].split) continue;

		//	basecode::Physics::PhysicsObject po;
		//	
		//	basecode::Math::vec3f splitp, splitn;

		//	splitp.set(2 *(basecode::rnd() - .5f), 2 *(basecode::rnd() - .5f), 0);
		//	splitn.set(basecode::rnd() - .5f, basecode::rnd() - .5f, basecode::rnd() - .5f);
		//	splitn.normalize();

		//	model.clear();
		//	hull = &objList[a].hull;
		//	for (unsigned int f = 0; f < hull->planes.size(); f++)
		//	{
		//		model.newFace(hull->planes[f].vertices[0], hull->planes[f].vertices[1], hull->planes[f].vertices[2]);
		//	}

		//	SplitModel(&model, &modelA, &modelB, splitn, splitp);

		//	fc = modelA.fcentroid();
		//	p = objList[a].position;
		//	modelA.center();
		//	objList[a].hull.importModel(modelA);
		//	objList[a].position += fc * 1.2f;
		//	objList[a].position.z = 0;

		//	po.velocity = objList[a].velocity;
		//	objList[a].velocity += splitn * -2;
		//	objList[a].velocity.z = 0;
		//	//objList[a].velocity.normalize();

		//	fc = modelB.fcentroid();
		//	modelB.center();
		//	
		//	po.hull.importModel(modelB);
		//	po.position = p + fc * 1.2f;
		//	po.position.z = 0;
		//	po.orientation = objList[a].orientation;
		//	
		//	po.velocity += splitn * 2;
		//	po.velocity.z = 0;
		//	//po.velocity.normalize();
		//	po.splitTime = (float)timer.time() + .25f;
		//	
		//	if (basecode::rnd() < .75f) po.split = false;
		//	if (basecode::rnd() < .75f) objList[a].split = false;
		//	

		//	objList.push_back(po);

		//	
		//	objList[a].splitTime = po.splitTime;
		//	

		//	break;
		//	
		//}
	}
			
}