#include "StationObject.h"

StationObject::StationObject()
{
	componentType = STATION_MFGPLANT;
	remove = false;
}

void StationObject::collision(unsigned int obj, basecode::Math::vec3f pnt)
{
}

bool StationObject::garbage()
{
	return remove;
}

void StationObject::render()
{
	glPushMatrix();

	glTranslatef(po.position.x, po.position.y, po.position.z);

	po.orientation.glMultMatrixf();

	glBegin(GL_TRIANGLES);

	basecode::Color c;
	basecode::vec3f n, v;

	basecode::Model *model = &((*modelListPtr)[modelid]);
		
	for (unsigned int f = 0; f < model->faces.size(); f++)
	{
		c = po.color;
		if (c.r == .2f) c.set(.75f);
		n = model->faces[f].normal.multiply(po.orientation);
		c.scale(.5f + .5f * n.dot(1, 1, 1));
		c.glColor3f();

		glVertex3fv(&model->vertices[model->faces[f].point_id[0]].x);
		glVertex3fv(&model->vertices[model->faces[f].point_id[1]].x);
		glVertex3fv(&model->vertices[model->faces[f].point_id[2]].x);
	}

	glEnd();
	
	glPopMatrix();
}

void StationObject::render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix)
{
	glUseProgram(shaderID);

	glm::mat4 model = *projectionMatrix * *viewMatrix * po.MVP;

	glUniformMatrix4fv(matrixID, 1, GL_FALSE, &model[0][0]);

	glEnableVertexAttribArray(0);
	glBindBuffer(GL_ARRAY_BUFFER, (*modelListPtr)[modelid].vertexBuffer);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, (void*)0);

	glEnableVertexAttribArray(1);
	glBindBuffer(GL_ARRAY_BUFFER, (*modelListPtr)[modelid].colorBuffer);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, (void*)0);

	glDrawArrays(GL_TRIANGLES, 0, (*modelListPtr)[modelid].faces.size() * 3);
 
	glDisableVertexAttribArray(0);
}


basecode::Physics::PhysicsObject* StationObject::physics()
{
	return &po;
}

void StationObject::set_modelid(unsigned int id)
{
	modelid = id;
}


void StationObject::sync(ISyncObject & syncObject, double time)
{
	throw "need to implement Game Object sync method";
}

void StationObject::update(float interval)
{
	po.update(interval);
}