#ifndef __STATION_OBJECT_H__
#define __STATION_OBJECT_H__

#include "ISyncObject.h"
#include "Physics.h"
#include "Game/IGameObject.h"

// Station Components
#define STATION_MFGPLANT 0
#define STATION_SCAFFOLD 1

class StationObject: public basecode::Game::IGameObject, public basecode::ISyncObject
{
private:
	basecode::Physics::PhysicsObject po;
	unsigned int modelid;
	unsigned int componentType;
	bool remove;

public:
	std::vector<basecode::Model> *modelListPtr;

	StationObject();

	void collision(unsigned int obj, basecode::Math::vec3f pnt);
	bool garbage();
	void render();
	void render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix);
	basecode::Physics::PhysicsObject* physics();
	void set_modelid(unsigned int id);
	void sync(ISyncObject & syncObject, double time);
	void update(float interval);
};


#endif __STATION_OBJECT_H__
