#ifndef __TALONFIVE_MODULE_H__
#define __TALONFIVE_MODULE_H__

#include <GL/glew.h>
#include <GL/glm/glm.hpp>
#include <GL/glm/gtc/matrix_transform.hpp>
#include <GL/glm/gtx/transform.hpp>
//#include <GL/glm/gtx/projection.hpp>

#include <time.h>
#include <string>
#include "IModule.h"
#include "Math.h"
#include "Model.h"
#include "Timer.h"
#include "Fps.h"
#include "glFont.h"
#include "Color.h"
#include "ActiveDebug.h"
#include "TalonFiveGameInputMapping.h"
#include "Game/InputObject.h"
#include "ISyncObject.h"
#include "Game/IGameObject.h"
#include "Physics.h"
#include "PTimer.h"
#include <utility>
#include <set>

// Game Objects
#include "AsteroidObject.h"
#include "EnemyObject.h"
#include "PlayerObject.h"
#include "StationObject.h"
#include "TetherObject.h"

namespace TalonFive {

	using namespace basecode::Math;
	using namespace glm;

	class Mouse
	{
	public:
		basecode::Math::vec2i position;
		basecode::Math::vec2i delta;
		double posxs, posys, poszs;
		double posxe, posye, posze;
		bool hold;
		bool middle_hold;

		Mouse();
	};

	class Gamepad
	{
	public:
		bool connected;
		int nAxes;
		int nButtons;
		float axisValue[16];
		float minValue[16];
		float maxValue[16];
		unsigned char buttons[32];

		Gamepad();
	};

	class TetherBeam
	{
	private:
		float expireTime;

	public:
		basecode::Game::IGameObject *tetherA, *tetherB;

		TetherBeam();
		void create(basecode::Game::IGameObject* to);
		void disable();
		void init();
		void setExpiration(float time);
		float expiration();
	
		void pair(basecode::Game::IGameObject* to);
		void update(float interval);
	};
	
	
	class Star
	{
	public:
		basecode::Math::vec2f position;
		basecode::Color c;
	};

	class Module : public basecode::IModule
	{
	private:
		basecode::Timer::Timer timer;
		basecode::Fps::Fps fps;
		basecode::glFont font;
		basecode::ActiveDebug ad_x, ad_y, ad_z;

		std::vector<Star> starList;
		unsigned int	starVertexBuffer;
		unsigned int	starColorBuffer;
		int asel;

		basecode::Math::vec3f camera, cameraTarget;

		basecode::Game::IGameObject* stationObj;

		std::vector<basecode::Game::IGameObject*> objList;
		std::vector<basecode::Physics::Volume> volumeList;
		std::vector<basecode::Model> modelList;

		std::set<std::pair<unsigned int, unsigned int>> nearList;

		std::vector<Gamepad> gamepad;
		float shipAngle;
		
		Mouse mouse;
		basecode::PTimer::PTimer ptimer;	
		

		TetherBeam tetherBeam;
		std::vector<TetherBeam> tetherList;
		double frameTime;
		float massDensity;
		float kbwait;

		basecode::Math::vec3f shipForce;

		mat4 viewMatrix;
		mat4 modelMatrix;
		mat4 projectionMatrix;
		mat4 mvpMat;

		unsigned int vertexArrayID;
		
		unsigned int bgShaderID;
		unsigned int fieldShaderID;
		unsigned int starShaderID;

		unsigned int matrixID;
		unsigned int textureID;
		unsigned int bgTextureID;
		unsigned int timeID;

		unsigned int vertexbuffer;
		unsigned int colorbuffer;

		unsigned int bgTex;
		unsigned int bgVertexBuffer;
		unsigned int bgUVBuffer;
		
		/*Hull hullA, hullB;
		PhysicsObject poA, poB;

		int divA, divB;

		
		bool collide;
		basecode::Math::vec3f vnorm;
		basecode::Math::vec3f ve0, ve1;*/

	public:
		Module();
		virtual ~Module();

		///Module initialization
		virtual void Init();
		GLuint LoadShaders(const char * vertex_file_path,const char * fragment_file_path);
		GLuint loadDDS(const char * imagepath);


		///Process the input, be sure to mark used input data as "handled" (ie to avoid a menu click to be also used as an in-game click)
		virtual void HandleInput(basecode::Input::InputObject & object);

		///Run module logic etc
		virtual void Run();

		///Render visuals
		virtual void Render();
		void Render_Background();
		void Render_HUD();
		void Render_Object(basecode::Physics::PhysicsObject* po);
		
		void SplitModel(basecode::Model* mSrc, basecode::Model* mDstA, basecode::Model* mDstB, basecode::Math::vec3f split_n, basecode::Math::vec3f split_p);

		///Module shutdown
		virtual void Shutdown();

	};
}


#endif   __TALONFIVE_MODULE_H__
