#include "TetherObject.h"

TetherObject::TetherObject()
{
	attachObj = 0;
	attached = false;
	pairObj = 0;
	targetDist = 30.0f;
	remove = false;
}

basecode::Game::IGameObject* TetherObject::attachedTo()
{
	return attachObj;
}

void TetherObject::pair(basecode::Game::IGameObject* obj, float dist)
{
	pairObj = obj;
	targetDist = dist;
}

bool TetherObject::garbage()
{
	return remove;
}

void TetherObject::collision(unsigned int obj, basecode::Math::vec3f pnt)
{
	if (obj == 0) return;

	printf("Collision with %d at point %s\n", obj, pnt.c_str());
	po.linearMomentum.set(0, 0, 0);
	attachObj = (*objList)[obj];
	attached = true;

	b = sqrt(4 * k * attachObj->physics()->mass);

	basecode::Math::vec3f relative;

	relative = po.position - attachObj->physics()->position;
	
	basecode::Math::Matrix trans;
	trans = attachObj->physics()->orientation;
	trans.transpose();

	// get collision point in attach object local coordinate system.
	relative = relative.multiply(trans);

	attachPoint = relative;
}

bool TetherObject::isAttached()
{
	return attached;
}

float TetherObject::length()
{
	return (pairObj->physics()->position - po.position).magnitude();
}

void TetherObject::render()
{
	glPushMatrix();

	glTranslatef(po.position.x, po.position.y, po.position.z);

	glBegin(GL_LINES);
	
	glColor4f(1, 1, .2f, 1);
	float r = 1;

	float amplitude;

	basecode::vec3f v0, v1;
	for (unsigned int i = 0; i <= 16; i++)
	{
		v1.set(r * cos(3.14159f * 2 * i / 16.0f), r * sin(3.14159f * 2 * i / 16.0f), 0);

		amplitude = 1 * sin(3.14159f * i / 16.0f);

		v1 += basecode::vec3f((basecode::rnd() - .5f) * amplitude, (basecode::rnd() - .5f) * amplitude, 0);

		if (i == 0) v0 = v1;
		glVertex3fv(&v0.x);
		glVertex3fv(&v1.x);

		v0 = v1;
	}

	basecode::vec3f ship = pairObj->physics()->position - po.position;

	
	for (unsigned int j = 0; j < 10; j++)
	{
		

	for (unsigned int i = 0; i <= 16; i++)
	{
		float a = basecode::rnd() * .2f;
		glColor4f(1 - a, 1 - a, .2f - a, 1 - a);

		v1.set(ship.x * i / 16.0f, ship.y * i / 16.0f, 0);

		amplitude = 5 * pow(sin(3.14159f * i / 16.0f), 10.0f);

		v1 += basecode::vec3f((basecode::rnd() - .5f) * amplitude, (basecode::rnd() - .5f) * amplitude, 0);

		if (i == 0) v0 = v1;
		glVertex3fv(&v0.x);
		glVertex3fv(&v1.x);

		v0 = v1;
	}
	}
	glEnd();

	
	glPopMatrix();
}


void TetherObject::render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix)
{
}

basecode::Physics::PhysicsObject* TetherObject::physics()
{
	return &po;
}


void TetherObject::setObjList(std::vector<basecode::Game::IGameObject*> *o)
{
	objList = o;
}

void TetherObject::setRemove()
{
	remove = true;
}


void TetherObject::sync(ISyncObject & syncObject, double time)
{
	throw "need to implement Game Object sync method";
}

void TetherObject::update(float interval)
{
	if (attached)
	{
		po.position = attachObj->physics()->position;
		po.position += attachPoint.multiply(attachObj->physics()->orientation);

		if (targetDist > 0 || (targetDist == 0 && ((TetherObject*)pairObj)->isAttached()))
		{
			basecode::vec3f delta = pairObj->physics()->position - po.position;
		
			float mag = delta.magnitude() - targetDist;
			delta.normalize();
			delta.scale(mag);

			attachObj->physics()->force += delta * k;

			attachObj->physics()->force += attachObj->physics()->linearVelocity * -b;
		}
	}
	po.update(interval);
}