#ifndef __TETHER_OBJECT_H__
#define __TETHER_OBJECT_H__

#include "ISyncObject.h"
#include "Physics.h"
#include "Game/IGameObject.h"

class TetherObject: public basecode::Game::IGameObject, public basecode::ISyncObject
{
private:
	basecode::Physics::PhysicsObject po;
	std::vector<basecode::Game::IGameObject*> *objList;
	bool attached;
	basecode::Game::IGameObject* pairObj;
	basecode::Game::IGameObject* attachObj;
	basecode::Math::vec3f attachPoint;
	float targetDist;
	bool remove;
	
public:
	TetherObject();
	float k;
	float b;

	basecode::Game::IGameObject* attachedTo();
	void collision(unsigned int obj, basecode::Math::vec3f pnt);
	bool isAttached();
	float length();
	void render();
	void render(unsigned int shaderID, unsigned int matrixID, glm::mat4 *projectionMatrix, glm::mat4 *viewMatrix);
	bool garbage();
	void pair(basecode::Game::IGameObject* obj, float dist);
	basecode::Physics::PhysicsObject* physics();
	void setObjList(std::vector<basecode::Game::IGameObject*> *o);
	void setRemove();
	void sync(ISyncObject & syncObject, double time);
	void update(float interval);
	void pullTo(unsigned int pobj);
};


#endif __TETHER_OBJECT_H__
