#include "Timer.h"

namespace basecode { namespace Timer {

	Timer::Timer() 
	{
		reset();
	}

	void Timer::reset()
	{
		curr_pad = 0;
		curr = 0;
		ctime = 0;
		ticks = 0;
		status = BC_TIMER_ACTIVE;
		update();
	}

	float Timer::delta()
	{
		return (float)curr_pad;
	}

	void Timer::pause()
	{
		status = BC_TIMER_PAUSED;
	}

	void Timer::resume()
	{
		status = BC_TIMER_ACTIVE;
		ticks = 0;
		update();
	}

	double Timer::time()
	{
		return ctime;
	}

	void Timer::update()
	{
		double pcurr = curr;
		curr = 0;
		if (status == BC_TIMER_ACTIVE)
		{
			if (ticks != 0) curr = glfwGetTime() - ticks;
			ctime += curr;

			curr_pad += (curr - curr_pad) * .2f;
			
			//if (ticks > 1000 && pcurr > 0 && curr / pcurr > 3) curr = pcurr;
			ticks = glfwGetTime();
		}
	}

}}