// Program:  glFont.h - OpenGL FreeType Wrapper
// Language: C++
// Author:   Daniel Kennedy (Syn9)
//
// Copyright (c) 2009-2012
// ____________________________________________________________________________
#ifndef INC_GLFONT_H
#define INC_GLFONT_H

#define GLFW_DLL
#include <GL/glfw.h>
#include <GL/glext.h>
#include <string>
#include <sstream>
#include <ft2build.h>
#include FT_FREETYPE_H
#include "Color.h"
#include <vector>
#include <fstream>

#define _WINDOWS
#define glfont_support_unicode

#ifdef glfont_support_unicode
	#define glfont_unicode_str_t std::wstring
	#define glfont_unicode_char_t wchar_t
#endif

#ifdef glfont_support_unicode

	#define glfont_str_t glfont_unicode_str_t
	#define glfont_char_t glfont_unicode_char_t

	#ifdef _WINDOWS
		#define glfont_gl_t GL_UNSIGNED_SHORT
	#else
		#define glfont_gl_t GL_UNSIGNED_INT

	#endif
#endif

namespace basecode
{

	using namespace std;
	
	struct glFontCharacter
	{
		int	width;
		int	height;
		int	top;
		int left;
		int advance;
		unsigned int page;
		float x, y, xw, yw;
		int id;
	};

	struct glFont
	{
		enum	formatEnum { TTF, BMFNT };
		formatEnum format;
		int		numChars;
		int		topRow;
		GLuint  *texture;
		GLuint	baseList;
		glFontCharacter	*fchars;
		unsigned int numPages;
		int		base;
		int		txWidth, txHeight;

		~glFont();
		void clear ();
		void createDisplayList (unsigned int ch);
		void createTexture (FT_Face face, unsigned int ch);
		void draw (string text);
		int getHeight (std::string text);
		int getWidth (std::string text);
		int getHeight (glfont_str_t text);
		int getWidth (glfont_str_t text);
		bool load (string filename, int fsize);
		bool load (string filename);
		bool load_ttf (string filename, int fsize);
		bool load_bmfnt (string filename);
		
		std::string prep (std::string text);
		void print (float x, float y, float xscale, float yscale, std::string text, Color c0);
		void print (float x, float y, float scale, std::string text, Color c0);
		void print (float x, float y, std::string text, Color c0);
		void print (float scale, std::string text, Color c0);
		void print (std::string text, Color c0);

		glfont_str_t prep (glfont_str_t text);
		void print (float x, float y, float xscale, float yscale, glfont_str_t text, Color c0);
		void print (float x, float y, float scale, glfont_str_t text, Color c0);
		void print (float x, float y, glfont_str_t text, Color c0);
		void print (float scale, glfont_str_t text, Color c0);
		void print (glfont_str_t text, Color c0);

	};

	template <class T>
	inline std::string str (const T& t)
	{
		std::stringstream ss;
		ss << t;
		return ss.str();
	}

	template <class T>
	inline std::wstring wstr (const T& t)
	{
		std::wstringstream ss;
		ss << t;
		return ss.str();
	}

	void str_explode(string haystack, string needle, vector<string> *result);

}

#endif
